/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.blocks.FakeLightBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.SpawnInterdictionHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControlState;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControllable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FloodlightBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IAdvancedDirectionalBE,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.ISpawnInterdiction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
EnergyTransferHandler.EnergyConnector,
IEBlockInterfaces.IStateBasedDirectional,
ComputerControllable {
    public int energyStorage = 0;
    private final int energyDraw;
    public final int maximumStorage;
    public boolean redstoneControlInverted;
    public Direction facing;
    public float rotY;
    public float rotX;
    public List<BlockPos> fakeLights;
    public List<BlockPos> lightsToBePlaced;
    public List<BlockPos> lightsToBeRemoved;
    final int timeBetweenSwitches = 20;
    int switchCooldown;
    private boolean shouldUpdate;
    public final ComputerControlState computerControl;
    public int turnCooldown;

    public FloodlightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FLOODLIGHT.get(), pos, state);
        this.energyDraw = (Integer)IEServerConfig.MACHINES.floodlight_energyDraw.get();
        this.maximumStorage = (Integer)IEServerConfig.MACHINES.floodlight_maximumStorage.get();
        this.redstoneControlInverted = false;
        this.facing = Direction.NORTH;
        this.rotY = 0.0f;
        this.rotX = 0.0f;
        this.fakeLights = new ArrayList<BlockPos>();
        this.lightsToBePlaced = new ArrayList<BlockPos>();
        this.lightsToBeRemoved = new ArrayList<BlockPos>();
        this.timeBetweenSwitches = 20;
        this.switchCooldown = 0;
        this.shouldUpdate = true;
        this.computerControl = new ComputerControlState();
        this.turnCooldown = 0;
    }

    @Override
    public void tickServer() {
        if (this.turnCooldown > 0) {
            --this.turnCooldown;
        }
        boolean activeBeforeTick = this.getIsActive();
        if (this.shouldUpdate) {
            this.lightsToBePlaced.clear();
            this.updateFakeLights(true, activeBeforeTick);
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
            this.shouldUpdate = false;
        }
        boolean enabled = this.computerControl.isAttached() ? this.computerControl.isEnabled() : this.isRSPowered() ^ this.redstoneControlInverted;
        if (this.energyStorage >= (!activeBeforeTick ? this.energyDraw * 10 : this.energyDraw) && enabled && this.switchCooldown <= 0) {
            this.energyStorage -= this.energyDraw;
            if (!activeBeforeTick) {
                this.setActive(true);
            }
        } else if (activeBeforeTick) {
            this.setActive(false);
            this.switchCooldown = 20;
        }
        --this.switchCooldown;
        boolean activeAfterTick = this.getIsActive();
        if (activeAfterTick != activeBeforeTick || this.f_58857_.m_46467_() % 512L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x1FF)) {
            this.markContainingBlockForUpdate(null);
            this.updateFakeLights(true, activeAfterTick);
            this.checkLight();
        }
        if (!activeAfterTick && !this.lightsToBePlaced.isEmpty()) {
            this.lightsToBePlaced.clear();
        }
        if (!(this.lightsToBePlaced.isEmpty() && this.lightsToBeRemoved.isEmpty() || this.f_58857_.m_46467_() % 8L != (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 7))) {
            BlockPos cc;
            Iterator<BlockPos> it = this.lightsToBePlaced.iterator();
            int timeout = 0;
            while (it.hasNext() && timeout++ < Math.max(16, 32 - this.lightsToBeRemoved.size())) {
                cc = it.next();
                this.f_58857_.m_7731_(cc, IEBlocks.Misc.FAKE_LIGHT.defaultBlockState(), 2);
                BlockEntity te = this.f_58857_.m_7702_(cc);
                if (te instanceof FakeLightBlock.FakeLightBlockEntity) {
                    ((FakeLightBlock.FakeLightBlockEntity)te).floodlightCoords = this.m_58899_();
                }
                this.fakeLights.add(cc);
                it.remove();
            }
            it = this.lightsToBeRemoved.iterator();
            while (it.hasNext() && timeout++ < 32) {
                cc = it.next();
                if (Utils.getExistingTileEntity(this.f_58857_, cc) instanceof FakeLightBlock.FakeLightBlockEntity) {
                    this.f_58857_.m_7471_(cc, false);
                }
                it.remove();
            }
        }
    }

    public void updateFakeLights(boolean deleteOld, boolean genNew) {
        Iterator<BlockPos> it = this.fakeLights.iterator();
        ArrayList<BlockPos> tempRemove = new ArrayList<BlockPos>();
        while (it.hasNext()) {
            BlockPos cc = it.next();
            BlockEntity te = this.f_58857_.m_7702_(cc);
            if (te instanceof FakeLightBlock.FakeLightBlockEntity) {
                if (!deleteOld) continue;
                tempRemove.add(cc);
                continue;
            }
            it.remove();
        }
        if (genNew) {
            float angle = this.facing == Direction.NORTH ? 180 : (this.facing == Direction.EAST ? 90 : (this.facing == Direction.WEST ? -90 : 0));
            float yRotation = this.rotY;
            double angleX = Math.toRadians(this.rotX);
            Vec3[] rays = new Vec3[]{new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0)};
            Matrix4 mat = new Matrix4();
            if (this.getFacing() == Direction.DOWN) {
                mat.scale(1.0, -1.0, 1.0);
            } else if (this.getFacing() != Direction.UP) {
                float f = this.facing == Direction.DOWN ? 180.0f : (this.facing == Direction.NORTH ? -90.0f : (angle = this.facing == Direction.SOUTH ? 90.0f : angle));
                if (this.getFacing().m_122434_() == Direction.Axis.X) {
                    mat.rotate(1.5707963267948966, -1.0, 0.0, 0.0);
                    mat.rotate(1.5707963267948966, 0.0, 0.0, -this.getFacing().m_122421_().m_122540_());
                } else {
                    mat.rotate(1.5707963267948966, -1.0, 0.0, 0.0);
                    if (this.getFacing() == Direction.SOUTH) {
                        mat.rotate(Math.PI, 0.0, 0.0, 1.0);
                        if (this.facing.m_122434_() == Direction.Axis.X) {
                            angle = -angle;
                        }
                    }
                }
            }
            double angleY = Math.toRadians(angle + yRotation);
            mat.rotate(angleY, 0.0, 1.0, 0.0);
            mat.rotate(-angleX, 1.0, 0.0, 0.0);
            rays[0] = mat.apply(rays[0]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            rays[1] = mat.apply(rays[1]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            rays[5] = mat.apply(rays[5]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            rays[6] = mat.apply(rays[6]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            rays[2] = mat.apply(rays[2]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            rays[3] = mat.apply(rays[3]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            rays[7] = mat.apply(rays[7]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            rays[8] = mat.apply(rays[8]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            rays[4] = mat.apply(rays[4]);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 0.0, 1.0, 0.0);
            rays[9] = mat.apply(rays[9]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            rays[10] = mat.apply(rays[10]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            rays[11] = mat.apply(rays[11]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            rays[12] = mat.apply(rays[12]);
            for (int ray = 0; ray < rays.length; ++ray) {
                int offset = ray == 0 ? 0 : (ray < 4 ? 3 : 1);
                this.placeLightAlongVector(rays[ray], offset, tempRemove);
            }
        }
        this.lightsToBeRemoved.addAll(tempRemove);
    }

    public void placeLightAlongVector(Vec3 vec, int offset, ArrayList<BlockPos> checklist) {
        Vec3 light = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82520_(0.0, 0.25, 0.0);
        int range = 32;
        HashSet<BlockPos> ignore = new HashSet<BlockPos>();
        ignore.add(this.m_58899_());
        BlockPos hit = Utils.rayTraceForFirst(vec.m_82549_(light), light.m_82520_(vec.f_82479_ * (double)range, vec.f_82480_ * (double)range, vec.f_82481_ * (double)range), this.f_58857_, ignore);
        double maxDistance = hit != null ? Vec3.m_82512_((Vec3i)hit).m_82520_(0.0, 0.25, 0.0).m_82557_(light) : (double)(range * range);
        for (int i = 1 + offset; i <= range; ++i) {
            BlockPos target = this.m_58899_().m_142022_((double)Math.round(vec.f_82479_ * (double)i), (double)Math.round(vec.f_82480_ * (double)i), (double)Math.round(vec.f_82481_ * (double)i));
            double dist = vec.f_82479_ * (double)i * vec.f_82479_ * (double)i + vec.f_82480_ * (double)i * vec.f_82480_ * (double)i + vec.f_82481_ * (double)i * vec.f_82481_ * (double)i;
            if (dist > maxDistance) break;
            if (this.getLevelNonnull().m_151570_(this.f_58858_) || target.equals((Object)this.m_58899_()) || !this.f_58857_.m_46859_(target)) continue;
            if (!checklist.remove(target)) {
                this.lightsToBePlaced.add(target);
            }
            i += 2;
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.getIsActive() ? 1024.0 : 0.0;
    }

    @Override
    public void setRemovedIE() {
        SpawnInterdictionHandler.removeFromInterdictionTiles(this);
        super.setRemovedIE();
    }

    @Override
    public void onChunkUnloaded() {
        SpawnInterdictionHandler.removeFromInterdictionTiles(this);
        super.onChunkUnloaded();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        SpawnInterdictionHandler.addInterdictionTile(this);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage = nbt.m_128451_("energy");
        this.redstoneControlInverted = nbt.m_128471_("redstoneControlInverted");
        this.facing = Direction.m_122376_((int)nbt.m_128451_("facing"));
        this.rotY = nbt.m_128457_("rotY");
        this.rotX = nbt.m_128457_("rotX");
        int lightAmount = nbt.m_128451_("lightAmount");
        this.fakeLights.clear();
        for (int i = 0; i < lightAmount; ++i) {
            int[] icc = nbt.m_128465_("fakeLight_" + i);
            this.fakeLights.add(new BlockPos(icc[0], icc[1], icc[2]));
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.markContainingBlockForUpdate(null);
        }
        if (descPacket && nbt.m_128441_("computerOn")) {
            boolean computerOn = nbt.m_128471_("computerOn");
            this.computerControl.setOneRef();
            this.computerControl.setEnabled(computerOn);
        } else {
            this.computerControl.clear();
        }
        if (this.f_58857_ != null && this.getIsActive()) {
            this.checkLight();
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128405_("energyStorage", this.energyStorage);
        nbt.m_128379_("redstoneControlInverted", this.redstoneControlInverted);
        nbt.m_128405_("facing", this.facing.ordinal());
        nbt.m_128350_("rotY", this.rotY);
        nbt.m_128350_("rotX", this.rotX);
        nbt.m_128405_("lightAmount", this.fakeLights.size());
        for (int i = 0; i < this.fakeLights.size(); ++i) {
            BlockPos cc = this.fakeLights.get(i);
            nbt.m_128385_("fakeLight_" + i, new int[]{cc.m_123341_(), cc.m_123342_(), cc.m_123343_()});
        }
        if (descPacket && this.computerControl.isAttached()) {
            nbt.m_128379_("computerOn", this.computerControl.isEnabled());
        }
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 1) {
            this.markContainingBlockForUpdate(null);
            this.checkLight();
            return true;
        }
        return super.m_7531_(id, arg);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "LV".equals(cableType.getCategory());
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        double y;
        double x;
        BlockPos otherPos = other.position();
        int xDif = otherPos.m_123341_() - this.f_58858_.m_123341_();
        int yDif = otherPos.m_123342_() - this.f_58858_.m_123342_();
        int zDif = otherPos.m_123343_() - this.f_58858_.m_123343_();
        return new Vec3(x, y, switch (this.getFacing().m_122434_()) {
            case Direction.Axis.Y -> {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double v0 = y = this.getFacing() == Direction.DOWN ? 0.9375 : 0.0625;
                yield Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
            case Direction.Axis.Z -> {
                double v1 = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                yield this.getFacing() == Direction.NORTH ? 0.9375 : 0.0625;
            }
            default -> {
                double v2 = x = this.getFacing() == Direction.WEST ? 0.9375 : 0.0625;
                double v3 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                yield Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        });
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return Shapes.m_83048_((double)(this.getFacing().m_122434_() == Direction.Axis.X ? 0.0 : 0.0625), (double)(this.getFacing().m_122434_() == Direction.Axis.Y ? 0.0 : 0.0625), (double)(this.getFacing().m_122434_() == Direction.Axis.Z ? 0.0 : 0.0625), (double)(this.getFacing().m_122434_() == Direction.Axis.X ? 1.0 : 0.9375), (double)(this.getFacing().m_122434_() == Direction.Axis.Y ? 1.0 : 0.9375), (double)(this.getFacing().m_122434_() == Direction.Axis.Z ? 1.0 : 0.9375));
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.f_58857_.f_46443_) {
            if (side.m_122434_() == this.getFacing().m_122434_()) {
                this.turnY(player.m_6144_(), false);
            } else {
                this.turnX(player.m_6144_(), false);
            }
        }
        return true;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.f_58857_.f_46443_) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new Component[]{new TranslatableComponent("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))});
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(Direction side, float hitX, float hitY, float hitZ, LivingEntity placer) {
        Direction f = Direction.m_122364_((double)placer.m_146908_());
        if (f == side.m_122424_()) {
            f = placer.m_146909_() > 0.0f ? Direction.DOWN : Direction.UP;
        }
        this.facing = f;
    }

    public boolean canComputerTurn() {
        return this.turnCooldown <= 0 || !this.getIsActive();
    }

    public void turnX(boolean dir, boolean throwException) {
        if (!this.canComputerTurn()) {
            if (throwException) {
                throw new RuntimeException("The floodlight can't turn again yet.");
            }
            return;
        }
        this.rotX = Math.min(191.25f, Math.max(-11.25f, this.rotX + (dir ? -11.25f : 11.25f)));
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 255, 0);
        if (this.getIsActive()) {
            this.turnCooldown = 20;
            this.shouldUpdate = true;
        }
    }

    public void turnY(boolean dir, boolean throwException) {
        if (!this.canComputerTurn()) {
            if (throwException) {
                throw new RuntimeException("The floodlight can't turn again yet.");
            }
            return;
        }
        this.rotY = (float)((double)this.rotY + (dir ? -11.25 : 11.25));
        this.rotY %= 360.0f;
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 255, 0);
        if (this.getIsActive()) {
            this.turnCooldown = 20;
            this.shouldUpdate = true;
        }
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return true;
    }

    @Override
    public int getRequestedEnergy() {
        if (this.energyStorage < this.maximumStorage) {
            return this.maximumStorage - this.energyStorage;
        }
        return 0;
    }

    @Override
    public void insertEnergy(int amount) {
        this.energyStorage += amount;
    }

    @Override
    public Stream<ComputerControlState> getAllComputerControlStates() {
        return Stream.of(this.computerControl);
    }
}

